(function () {
    var myConnector = tableau.makeConnector();

    var resas_api_key = "TfSFQAUFuciDmNDDqt5YaJ1QRf8cBFyCaUgsEt5U"

    myConnector.getSchema = function (schemaCallback) {
    var cols = [
        { id : "prefCode", dataType : tableau.dataTypeEnum.string },
        { id : "year", dataType : tableau.dataTypeEnum.int },
        { id : "class", dataType : tableau.dataTypeEnum.string },
        { id : "man", dataType : tableau.dataTypeEnum.int},
        { id : "manPercent", dataType : tableau.dataTypeEnum.float },
        { id : "woman", dataType : tableau.dataTypeEnum.int},
        { id : "womanPercent", dataType : tableau.dataTypeEnum.float}
    ];

    var tableInfo = {
        id : "Tokyo",
        alias : "RESAS data",
        columns : cols
    };

    schemaCallback([tableInfo]);
};

    myConnector.getData = function(table, doneCallback) {
    $.ajax({ 
        url: "https://opendata.resas-portal.go.jp/api/v1/population/composition/pyramid?cityCode=-&yearRight=1980&prefCode=13&yearLeft=2040",
        dataType: 'json',
        type: "GET",
        headers: {
            'X-API-KEY': resas_api_key
        }, 
        async: "false" ,
        success: function(resp) {
            var tableData = []; 

           for ( i = 0; i < resp.result.yearRight.data.length; i++ ) {
                tableData.push({
                "prefCode": "Tokyo",
                "year": resp.result.yearRight.year,
                "class": resp.result.yearRight.data[i].class,
                "man": resp.result.yearRight.data[i].man,
                "manPercent": resp.result.yearRight.data[i].manPercent,
                "woman": resp.result.yearRight.data[i].woman,
                "womanPercent": resp.result.yearRight.data[i].womanPercent
            });
        }

            for ( i = 0; i < resp.result.yearLeft.data.length; i++ ) {
                tableData.push({
                "prefCode": "Tokyo",
                "year": resp.result.yearLeft.year,
                "class": resp.result.yearLeft.data[i].class,
                "man": resp.result.yearLeft.data[i].man,
                "manPercent": resp.result.yearLeft.data[i].manPercent,
                "woman": resp.result.yearLeft.data[i].woman,
                "womanPercent": resp.result.yearLeft.data[i].womanPercent
            });
        }


        table.appendRows(tableData);
        doneCallback();
        },
    });
};

    tableau.registerConnector(myConnector);
})();

$(document).ready(function () {
    $("#submitButton").click(function () {
        tableau.connectionName = "RESAS Data";
        tableau.submit();
    });
});
